package data.scripts.shipsystems.ai;

import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.Iterator;
import java.util.List;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

import static data.scripts.everyframe.SWP_FluxDisturberPlugin.DISTURBER_RANGE;

public class SWP_FluxDisturberAI implements ShipSystemAIScript {

    public static final float HARD_FLUX_THRESHOLD = 0.5f;
    public static final float REMAINING_FLUX_THRESHOLD = 10000f;
    public static final float SECONDS_BETWEEN_USES = 2f;
    public static final float TARGET_FLUX_REMAINING_BONUS = 1f;
    public static final float TARGET_FLUX_REMAINING_BONUS_THRESHOLD = 4000f;

    private CombatEngineAPI engine;
    private ShipAPI ship;
    private ShipSystemAPI system;
    private float timer = 0f;
    private final IntervalUtil tracker = new IntervalUtil(0.5f, 1f);

    @Override
    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (engine == null) {
            return;
        }

        if (engine.isPaused()) {
            return;
        }

        tracker.advance(amount);

        if (timer > 0f) {
            timer -= amount;
        }

        if (tracker.intervalElapsed()) {
            if (system.getCooldownRemaining() > 0) {
                return;
            }

            float targetedAllies = 0f;
            float targetedEnemies = 0f;

            List<ShipAPI> possibleTargets = CombatUtils.getShipsWithinRange(ship.getLocation(), DISTURBER_RANGE);
            Iterator<ShipAPI> iter = possibleTargets.iterator();
            while (iter.hasNext()) {
                ShipAPI possibleTarget = iter.next();
                if (possibleTarget.isHulk() || possibleTarget.getFluxTracker().isOverloaded() ||
                        possibleTarget.getFluxTracker().isVenting() || target == ship) {
                    iter.remove();
                } else if (possibleTarget.getCollisionClass() == CollisionClass.NONE) {
                    iter.remove();
                } else {
                    float value = 0f;
                    float fluxRemaining = possibleTarget.getFluxTracker().getMaxFlux() -
                          possibleTarget.getFluxTracker().getCurrFlux();
                    float bonus = TARGET_FLUX_REMAINING_BONUS *
                          Math.max(0f, (TARGET_FLUX_REMAINING_BONUS_THRESHOLD - fluxRemaining) /
                                   TARGET_FLUX_REMAINING_BONUS_THRESHOLD) + 1f;

                    if (possibleTarget.isFighter()) {
                        value = 0.25f * bonus;
                    } else if (possibleTarget.isFrigate()) {
                        value = 1.5f * bonus;
                    } else if (possibleTarget.isDestroyer()) {
                        value = 2f * bonus;
                    } else if (possibleTarget.isCruiser()) {
                        value = 1.5f * bonus;
                    } else if (possibleTarget.isCapital()) {
                        value = 1f * bonus;
                    }

                    if (possibleTarget.getOwner() == ship.getOwner() ^
                            ship.getHullSpec().getBaseHullId().contentEquals("ssp_excelsior")) {
                        if (possibleTarget.isFighter() && possibleTarget.getOwner() == ship.getOwner()) {
                            /* Friendly fighters are ignored */
                        } else {
                            targetedAllies += value * 0.75f;
                        }
                    } else {
                        targetedEnemies += value;
                    }
                }
            }

            boolean shield = false;
            if (ship.getShield() != null) {
                if (ship.getShield().isOn()) {
                    shield = true;
                }
            }

            if (shield) {
                if (timer <= 0f && targetedEnemies >= 5f && targetedEnemies - targetedAllies >= 2f &&
                        ship.getFluxTracker().getMaxFlux() -
                        ship.getFluxTracker().getCurrFlux() >=
                        REMAINING_FLUX_THRESHOLD &&
                        ship.getFluxTracker().getHardFlux() / ship.getFluxTracker().getMaxFlux() <= HARD_FLUX_THRESHOLD) {
                    if (!system.isActive()) {
                        ship.useSystem();
                    }
                } else {
                    if (system.isActive()) {
                        ship.useSystem();
                        timer = SECONDS_BETWEEN_USES;
                    }
                }
            } else {
                if (timer <= 0f && targetedEnemies - targetedAllies >= 2f && ship.getFluxTracker().getMaxFlux() -
                        ship.getFluxTracker().getCurrFlux() >=
                        REMAINING_FLUX_THRESHOLD && ship.getFluxTracker().getHardFlux() /
                        ship.getFluxTracker().getMaxFlux() <=
                        HARD_FLUX_THRESHOLD) {
                    if (!system.isActive()) {
                        ship.useSystem();
                    }
                } else {
                    if (system.isActive()) {
                        ship.useSystem();
                        timer = SECONDS_BETWEEN_USES;
                    }
                }
            }
        }
    }

    @Override
    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.system = system;
        this.engine = engine;
    }

}
